/*
 * aescrypt.h
 *
 * Copyright (C) 2007, 2008, 2009
 *
 * This software is licensed as "freeware."  Permission to distribute
 * this software in source and binary forms is hereby granted without a
 * fee.  THIS SOFTWARE IS PROVIDED 'AS IS' AND WITHOUT ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY DAMAGES RESULTING FROM
 * THE USE OF THIS SOFTWARE, EITHER DIRECTLY OR INDIRECTLY, INCLUDING,
 * BUT NOT LIMITED TO, LOSS OF DATA OR DATA BEING RENDERED INACCURATE.
 *
 */

#ifndef __AESCRYPT_H__
#define __AESCRYPT_H__

#include <stdio.h>

#include "aes.h"
#include "sha256.h"

typedef struct {
    char aes[3];
    unsigned char version;
    unsigned char last_block_size;
} aescrypt_hdr;

typedef unsigned char sha256_t[32];

#ifdef __cplusplus
extern "C" {
#endif
int encrypt_stream_hardcoded(FILE *infp, FILE *outfp, char *outParam_ErrorMessageBuffer);
int decrypt_stream_hardcoded(FILE *infp, FILE *outfp, char *outParam_ErrorMessageBuffer);
#ifdef __cplusplus
}
#endif

#endif // __AESCRYPT_H__
